(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4478,        178]*)
(*NotebookOutlinePosition[      5128,        201]*)
(*  CellTagsIndexPosition[      5084,        197]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(**\[CapitalDelta]V\)\ REQUIRED\ TO\ MOVE\ EROS\ 
      \(CALCULATIONS**\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1.458336481*\((1 +  .223030922)\)\)], "Input"],

Cell[BoxData[
    \(1.78359061094366522`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(1.78359061094366522` - \ aphelion\ distance\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\t\@\(4 \( \[Pi]\^2\) 
        \((2\/1.78359061094366522` - 1\/1.458336481)\)\)\)\)], "Input"],

Cell[BoxData[
    \(4.14700106697539361`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(4.14700106697539361` - \ velocity\ \((AU/yr)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(4.14700106697539361`*\((1.495978707*10^11)\)\)\/\(365.2564*24*3600
        \)\)], "Input"],

Cell[BoxData[
    \(19658.3916110832834`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(19658.3916110832834` - \ velocity\ \((m/s)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(19658.3916110832834`/1000\)], "Input"],

Cell[BoxData[
    \(19.6583916110832834`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(19.6583916110832834` - \ velocity\ \((km/s)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(0.987026072818613897` + 1.78359061094366522`\)], "Input"],

Cell[BoxData[
    \(2.7706166837622792`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(2.7706166837622792`/2\)], "Input"],

Cell[BoxData[
    \(1.3853083418811396`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(1.3853083418811396`\  - \ 
      semimajor\ axis\ after\ perihelion\ distance\ lower\ to\  .98\ AU\ 
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\t\@\(4 \( \[Pi]\^2\) 
        \((2\/1.78359061094366522` - 1\/1.3853083418811396`)\)\)\)\)], "Input"],

Cell[BoxData[
    \(3.97121469954959582`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(3.97121469954959582` - \ velocity\ \((AU/yr)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(3.97121469954959582`*\((1.495978707*10^11)\)\)\/\(365.2564*24*3600
        \)\)], "Input"],

Cell[BoxData[
    \(18825.0961296170871`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(18825.0961296170871` - \ velocity\ \((m/s)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(18825.0961296170871`/1000\)], "Input"],

Cell[BoxData[
    \(18.8250961296170871`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(18.8250961296170871` - \ velocity\ \((km/s)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(19.6583916110832834 - 18.8250961296170871`\)], "Input"],

Cell[BoxData[
    \(0.833295481466194587`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(0.833295481466194587` - \ 
      \[CapitalDelta]V\ required\ to\ make\ Eros\ cross\ Earth' s\ orbit\ 
        \((km/s)\)\)], "Input"]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 572}},
WindowSize->{480, 448},
WindowMargins->{{20, Automatic}, {16, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 108, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[1842, 55, 66, 1, 30, "Input"],
Cell[1911, 58, 54, 1, 29, "Output"]
}, Open  ]],
Cell[1980, 62, 76, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2081, 67, 116, 2, 50, "Input"],
Cell[2200, 71, 54, 1, 29, "Output"]
}, Open  ]],
Cell[2269, 75, 79, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2373, 80, 112, 2, 42, "Input"],
Cell[2488, 84, 54, 1, 29, "Output"]
}, Open  ]],
Cell[2557, 88, 77, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2659, 93, 58, 1, 30, "Input"],
Cell[2720, 96, 54, 1, 29, "Output"]
}, Open  ]],
Cell[2789, 100, 78, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2892, 105, 77, 1, 30, "Input"],
Cell[2972, 108, 53, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3062, 114, 54, 1, 30, "Input"],
Cell[3119, 117, 53, 1, 29, "Output"]
}, Open  ]],
Cell[3187, 121, 142, 3, 50, "Input"],

Cell[CellGroupData[{
Cell[3354, 128, 124, 2, 50, "Input"],
Cell[3481, 132, 54, 1, 29, "Output"]
}, Open  ]],
Cell[3550, 136, 79, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[3654, 141, 112, 2, 42, "Input"],
Cell[3769, 145, 54, 1, 29, "Output"]
}, Open  ]],
Cell[3838, 149, 77, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[3940, 154, 58, 1, 30, "Input"],
Cell[4001, 157, 54, 1, 29, "Output"]
}, Open  ]],
Cell[4070, 161, 78, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[4173, 166, 75, 1, 30, "Input"],
Cell[4251, 169, 55, 1, 29, "Output"]
}, Open  ]],
Cell[4321, 173, 153, 3, 50, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

